/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Window window; // gui window
Menu   menu  ; // gui menu
/******************************************************************************/
void InitPre()
{
   App.name="Window Menu";
   App.flag=APP_NO_FX;
   PakAdd("../data/engine.pak");
   D.mode(800,600);
}
/******************************************************************************/
// here are defined procedures which are going to be used by menu commands when activated
void MenuFileNew (){}
void MenuFileOpen(){}
void MenuFileSave(){}
void MenuFileExit(){StateExit.set();}
/******************************************************************************/
Bool Init()
{
   Text_ds.color =BLACK;
   Text_ds.shadow=0;

   Gui+=window.create(Rect(-0.5,-0.4,0.5,0.4),"Window with menu");
   {
      using namespace MenuDefs; // use this namespace to simplify menu creation
      // from now on (in current scope) N is a menu node
      N n; // let's start with main node
      {
         N &f=(n+="File"); // add "File" element to main node, and store it's reference in 'f'
         f.New().create("New" ,MenuFileNew ,Ksc(KB_N,KSC_CTRL)); // add "New"  command to 'f', giving it's procedure and keyboard shortcut (ctrl+n)
         f.New().create("Open",MenuFileOpen,Ksc(KB_O,KSC_CTRL)); // add "Open" command to 'f', giving it's procedure and keyboard shortcut (ctrl+o)
         f.New().create("Save",MenuFileSave,Ksc(KB_S,KSC_CTRL)); // add "Save" command to 'f', giving it's procedure and keyboard shortcut (ctrl+s)
         f++; // add empty line
         f.New().create("Exit",MenuFileExit,Ksc(KB_X,KSC_CTRL)); // add "Exit" command to 'f', giving it's procedure and keyboard shortcut (ctrl+x)
      }
      {
         N &e=(n+="Edit");
         e.New().create("Option",CMENU_TOGGLABLE); // giving CMENU_TOGGLE flag means that we can toggle this element
         {
            N &c=(e+="Children");
            c+=            "child 1";
            c.New().create("child 2").setDesc("This is child 2"); // this element has a description which will be shown when mouse cursor stops on the element
            c.New().create("child 3",CMENU_TOGGLABLE).setOn();    // this element can be toggled and is checked by default
         }
      }
      window+=menu.create(n); // create menu from nodes and add it to window
   }
   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   Gui.update();
   return true;
}
/******************************************************************************/
void Draw()
{
   D  .clear(WHITE);
   Gui.draw ();
   D  .text (0,-0.7,S+"'Option' is "+menu("edit/option")); // draw state of "option" located in "edit" using operator() method
   
   // Another way of checking if a command has been selected is to use 'pushed' method, like this:
   if(menu.pushed("edit/children/child 1"))
   {
      // if we're here then "edit/children/child 1" has been selected
   }
}
/******************************************************************************/
